﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace GenerujZabezpieczenia
{
    class Program
    {
        static readonly string oznaczenieWstawki = "// ZABEZPIECZ";
        static int numerEtykiety = 0;   // służy do generacji unikalnych etykiet do skoków

        static readonly string[] statyczneWstawki = {"__asm TEST EAX,EBX;" , "__asm TEST EAX,EAX;", "__asm TEST EAX,ECX;",
            "__asm TEST EBX,EBX;", "__asm TEST EBX,ECX;", "__asm TEST ECX,ECX;", "__asm MOV EAX, EBX;	",
            "__asm TEST EBX,EAX;", "__asm TEST EAX,ECX;", "__asm TEST ECX,EAX;", "__asm PUSH EAX; __asm POPF",
            "__asm PUSH EBX; __asm POPF", "__asm PUSH ECX; __asm POPF", "__asm PUSH EAX; __asm POP EBX",
            "__asm PUSHF; __asm POP EAX", "__asm PUSHF; __asm POP EBX", "__asm PUSHF; __asm POP ECX",
            "__asm ADD EAX, EBX;",  "__asm ADD EAX, ECX;",  "__asm INC EAX;", "__asm INC EBX;", "__asm INC ECX;", 
            "__asm MOV EAX, 0; ", "__asm MOV EBX, 0; ", "__asm MOV ECX, 0; "};
        static readonly string początekWstawki = "__asm PUSH EAX; __asm  PUSH EBX; __asm  PUSH ECX; __asm PUSHF;\r\n";
        static readonly string koniecWstawki = "__asm POPF; __asm POP ECX; __asm POP EBX; __asm POP EAX;\r\n";

        static Random rd = new Random((int) (DateTime.Now.Ticks) );

        static string UtwórzEtykietę()
        {
            numerEtykiety++;
            return "security_lab_" + numerEtykiety.ToString();
        }

        /// <summary>
        /// Tworzy losowy statyczny ciąg wstawek assemblerowych, od 1 do 9 rozkazów
        /// </summary>
        /// <returns></returns>
        static string UtwórzStatycznąWstawkę()
        {            
            int ile = rd.Next(1, 10);
            string retWart = "";
            for (int i = 0; i < ile; i++)
			{
                retWart += statyczneWstawki[rd.Next(0, statyczneWstawki.Length)] + "\r\n";
			}
            return retWart;
        }

        /// <summary>
        /// Tworzy kilka skoków i trochę statycznego assemblera
        /// </summary>
        /// <returns></returns>
        static string UtwórzSztuczneSkoki()
        {
            string retWart = "";
            string etykieta1 = UtwórzEtykietę();
            string etykieta2 = UtwórzEtykietę();
            string etykieta3 = UtwórzEtykietę();
            retWart += "__asm JMP " + etykieta1 + ";\r\n";
            retWart += etykieta2 + ":" + UtwórzStatycznąWstawkę();
            retWart += "__asm JMP " + etykieta3 + ";\r\n";           
            retWart += etykieta1 + ":" + UtwórzStatycznąWstawkę();
            retWart += "__asm JMP " + etykieta2 + ";\r\n";
            retWart += etykieta3 + ":" + UtwórzStatycznąWstawkę();
            return retWart;
        }

        static string UtwórzWstawkę()
        {
            string ciągPodmiany = początekWstawki;
            int ile = rd.Next(1, 3);
            for (int i = 0; i < ile; i++)
            {
                if(rd.Next(0,2) == 0)
                    ciągPodmiany += UtwórzSztuczneSkoki();
                else
                    ciągPodmiany += UtwórzStatycznąWstawkę();
            }
            return ciągPodmiany + koniecWstawki;
        }

        /// <summary>
        /// Główna funkcja programu podmieniająca wstawki
        /// </summary>
        /// <param name="aPath"></param>
        static void ModyfikujPlik(string aŚcieżka)
        {
            // odczyt pliku
            TextReader reader = new StreamReader(aŚcieżka, System.Text.Encoding.Default);
            string zawartość = reader.ReadToEnd();
            reader.Close();

            // modyfikacja zawartości
            int ile = 0;
            while (zawartość.IndexOf(oznaczenieWstawki) != -1)
            {
                int indeksWstawki = zawartość.IndexOf(oznaczenieWstawki);
                string wstawka = UtwórzWstawkę();
                zawartość = zawartość.Substring(0, indeksWstawki) + wstawka + zawartość.Substring(indeksWstawki + oznaczenieWstawki.Length);
                ile++;
            }
            
            // zapis pliku
            TextWriter writer = new StreamWriter(aŚcieżka, false, System.Text.Encoding.Default);
            writer.Write(zawartość);
            writer.Close();

            Console.WriteLine(aŚcieżka + " został zmodyfikowany " + ile.ToString() + " razy");
        }


        static void Main(string[] args)
        {
            if(args.Length < 1) 
                Console.WriteLine("Uruchom program z parametrem określającym modyfikowany plik.");
            else if(!File.Exists(args[0]))
                Console.WriteLine("Podany plik nie istnieje.");
            else ModyfikujPlik(args[0]);
        }
    }
}
